#include <cmath>
#include "Player.h"
#include "gameloop.h"


SDL_Surface* fireFighterRPic1 = NULL;
SDL_Surface* fireFighterLPic1 = NULL;
SDL_Surface* fireFighterUPic1 = NULL;
SDL_Surface* fireFighterDPic1 = NULL;
SDL_Surface* fireFighterRPic2 = NULL;
SDL_Surface* fireFighterLPic2 = NULL;
SDL_Surface* fireFighterUPic2 = NULL;
SDL_Surface* fireFighterDPic2 = NULL;

SDL_Surface* bonusRPic1 = NULL;
SDL_Surface* bonusRPic2 = NULL;
SDL_Surface* bonusLPic1 = NULL;
SDL_Surface* bonusLPic2 = NULL;

SDL_Surface* housePic1 = NULL;
SDL_Surface* housePic2 = NULL;
SDL_Surface* housePic3 = NULL;
SDL_Surface* housePic4 = NULL;

SDL_Surface* bonusHousePic = NULL;

SDL_Surface* firePic1 = NULL;
SDL_Surface* firePic2 = NULL;
SDL_Surface* firePic3 = NULL;


inline float distance(float x, float y)
{
    return sqrt(x*x + y*y);
}
inline float distance2(float x, float y)
{
    return x*x + y*y;
}
inline float distance(float x, float y, float x2, float y2)
{
    float xx = x - x2;
    float yy = y - y2;
    return sqrt(xx*xx + yy*yy);
}
inline float distance2(float x, float y, float x2, float y2)
{
    float xx = x - x2;
    float yy = y - y2;
    return xx*xx + yy*yy;
}


House::House(float x, float y)
    : x(x)
    , y(y)
    , radius(10)
    , hp(100)
    , pic(NULL)
{
    switch(rand()%4)
    {
        case 0:
            pic = housePic1;
        break;
        case 1:
            pic = housePic2;
        break;
        case 2:
            pic = housePic3;
        break;
        case 3:
            pic = housePic4;
        break;
    }
}

House::~House()
{
    
}

void House::update(GameState* state, float dt)
{
    for(list<Fire>::iterator e = state->fires.begin(); e != state->fires.end(); e++)
    {
        if(((*e).size + 20)*((*e).size + 20) > distance2(x, y, (*e).x, (*e).y))
        {
            hp -= 5*dt;
        }
    }
}

void House::draw(SDL_Surface* screen)
{
    //SPG_RectFilled(screen, x - radius, y - radius, x + radius, y + radius, RGB_BLUE);
    SPG_DrawCenter(pic, screen, x, y);
}


Fire::Fire(float x, float y)
    : x(x)
    , y(y)
    , velx(0)
    , vely(0)
    , speed(5)
    , size(size)
    , burnTimer(0.200)
    , spawnTimer(rand()%1000/1000.0 * 1.0 + 0.1)
    , growthFactor(10)
    , deathFactor(10)
    , isWild(true)
    , maxSize(10)
{
    float angle = rand()%1000/1000.0 * PI2;
    velx = speed*cos(angle);
    vely = speed*sin(angle);
    
    vector<ASFrame> fs;
    fs.push_back(ASFrame(firePic1, 50));
    fs.push_back(ASFrame(firePic2, 50));
    fs.push_back(ASFrame(firePic3, 50));
    anim.loadAnim(fs);
}
Fire::Fire(const Fire& fire)
    : x(fire.x)
    , y(fire.y)
    , velx(0)
    , vely(0)
    , speed(fire.speed)
    , size(fire.size)
    , burnTimer(0.200)
    , spawnTimer(rand()%1000/1000.0 * 1.0 + 0.1)
    , growthFactor(fire.growthFactor)
    , deathFactor(fire.deathFactor)
    , isWild(fire.isWild)
    , maxSize(fire.maxSize)
{
    float angle = rand()%1000/1000.0 * PI2;
    velx = speed*cos(angle);
    vely = speed*sin(angle);
    
    vector<ASFrame> fs;
    fs.push_back(ASFrame(firePic1, 50));
    fs.push_back(ASFrame(firePic2, 50));
    fs.push_back(ASFrame(firePic3, 50));
    anim.loadAnim(fs);
}

void Fire::update(GameState* state, float dt)
{
    x += velx*dt;
    y += vely*dt;
    
    float angle = atan2(vely, velx);
    
    angle += (rand()%1000/1000.0 - 0.5) * PI_4 * dt;
    
    velx = speed*cos(angle);
    vely = speed*sin(angle);
}

void Fire::updateEffects(GameState* state, float dt)
{
    if(burnTimer < 0)
    {
        SPG_CircleFilledBlend(state->grass, x, y, size, RGB_BROWNDK, 5);
        
        if(isWild)
            state->burnMap->burn(x - size/2, y - size/2, x + size/2, y + size/2);
        else
            state->burnMap->burn(x - size/1.0, y - size/1.0, x + size/1.0, y + size/1.0);
        
        burnTimer = 0.200;
    }
    else
        burnTimer -= dt;
        
    if(spawnTimer < 0)
    {
        state->addFire(this);
        
        spawnTimer = rand()%1000/1000.0 * 1.0 + 0.1;
    }
    else
        spawnTimer -= dt;
    
    float burnValue = state->burnMap->getValue(x, y)*dt;
    if(burnValue >= 0)
        size += growthFactor*burnValue;
    else
        size += deathFactor*burnValue;
    if(size < 0)
        size = 0;
    else if(size > maxSize)
        size = maxSize;
}

void Fire::draw(SDL_Surface* screen)
{
    //SPG_CircleFilledBlend(screen, x, y, size*1.1, RGB_RED, 200);
    //SDL_Surface* s = SPG_Scale(pic, size/100, size/100);
    //SPG_Draw(s, screen, x - s->w/2, y - s->h/2);
    //SDL_FreeSurface(s);
    anim.drawScaledCenter(screen, x, y, size/80);
}

Fire::~Fire()
{
    
}





Player::Player(bool bonus)
    : x(400)
    , y(400)
    , velx(0)
    , vely(0)
    , accx(0)
    , accy(0)
    , burning(false)
    , burnTimer(0.100)
    , hp(100)
    , direction(0)
{
    if(!bonus)
    {
        vector<ASFrame> fs;
        fs.push_back(ASFrame(fireFighterRPic1, 200));
        fs.push_back(ASFrame(fireFighterRPic2, 200));
        animRight.loadAnim(fs);
        fs.clear();
        
        fs.push_back(ASFrame(fireFighterLPic1, 200));
        fs.push_back(ASFrame(fireFighterLPic2, 200));
        animLeft.loadAnim(fs);
        fs.clear();
        
        fs.push_back(ASFrame(fireFighterUPic1, 200));
        fs.push_back(ASFrame(fireFighterUPic2, 200));
        animUp.loadAnim(fs);
        fs.clear();
        
        fs.push_back(ASFrame(fireFighterDPic1, 200));
        fs.push_back(ASFrame(fireFighterDPic2, 200));
        animDown.loadAnim(fs);
    }
    else
    {
        vector<ASFrame> fs;
        fs.push_back(ASFrame(bonusRPic1, 200));
        fs.push_back(ASFrame(bonusRPic2, 200));
        animRight.loadAnim(fs);
        fs.clear();
        
        fs.push_back(ASFrame(bonusLPic1, 200));
        fs.push_back(ASFrame(bonusLPic2, 200));
        animLeft.loadAnim(fs);
        fs.clear();
        
        fs.push_back(ASFrame(bonusRPic1, 200));
        fs.push_back(ASFrame(bonusRPic2, 200));
        animUp.loadAnim(fs);
        fs.clear();
        
        fs.push_back(ASFrame(bonusLPic1, 200));
        fs.push_back(ASFrame(bonusLPic2, 200));
        animDown.loadAnim(fs);
    }
}

Player::~Player()
{
    
}

void Player::update(GameState* state, float dt)
{
    int terrain = state->terrainMap->getValue(x + velx*dt, y + vely*dt);
    if(terrain != 3)
    {
        x += velx*dt;
        y += vely*dt;
    }
    
    if(x < 0)
        x = 0;
    else if(x > state->screen->w)
        x = state->screen->w;
    if(y < 0)
        y = 0;
    else if(y > state->screen->h)
        y = state->screen->h;
    
    float speedFactor = 1.0f;
    terrain = state->terrainMap->getValue(x, y);
    switch(terrain)
    {
        case 1:
            speedFactor = 0.4f;
            break;
        case 2:
            speedFactor = 0.2f;
            break;
        case 3:
            speedFactor = 0.05f;
            break;
    }
    velx += speedFactor*accx*dt;
    vely += speedFactor*accy*dt;
    
    float angle = atan2(vely, velx);
    float vel = sqrt(velx*velx + vely*vely);
    if(fabs(accx) < 0.1 && fabs(accy) < 0.1)
        vel -= 1000*dt;
    if(vel < 0)
        vel = 0;
    if(vel > 150*speedFactor)
        vel = 150*speedFactor;
    
    velx = vel*cos(angle);
    vely = vel*sin(angle);
    
    if(vel > 0.1)
    {
        if(angle >= -PI_4 && angle <= PI_4)
            direction = 0;
        else if(angle > PI_4 && angle <= PI3_4)
            direction = 3;
        else if(angle < -PI3_4 || angle >= PI3_4)
            direction = 2;
        else if(angle < -PI_4 && angle >= -PI3_4)
            direction = 1;
    }
}

void Player::updateEffects(GameState* state, float dt)
{
    if(burning)
    {
        if(burnTimer < 0)
        {
            int mx, my;
            if(SDL_GetMouseState(&mx, &my) | SDL_BUTTON_LEFT)
                continueBurn(state, mx, my);
            burnTimer = 0.005;
        }
        else
            burnTimer -= dt;
    }
    
    hp += 0.1*dt;
    for(list<Fire>::iterator e = state->fires.begin(); e != state->fires.end(); e++)
    {
        if(((*e).size + 20)*((*e).size + 20) > distance2(x, y, (*e).x, (*e).y))
        {
            if((*e).size > 2.5 || (*e).isWild)
                hp -= 5*dt;
            if(!burning)
                (*e).size -= 50*dt;
            if((*e).size < 0)
                (*e).size = 0;
        }
    }
}


void Player::draw(SDL_Surface* screen)
{
    //SPG_RectFilled(screen, x - 10, y - 10, x + 10, y + 10, RGB_RED);
    switch(direction)
    {
        case 0:
            animRight.drawCenter(screen, x, y);
        break;
        case 1:
            animUp.drawCenter(screen, x, y);
        break;
        case 2:
            animLeft.drawCenter(screen, x, y);
        break;
        case 3:
            animDown.drawCenter(screen, x, y);
        break;
    }
}

void Player::drawAim(GameState* state, float x, float y)
{
    float dist = distance(x, y, this->x, this->y);
    
    if(dist < 70)
        SPG_Circle(state->screen, x, y, 4, RGB_YELLOW);
    else
    {
        float angle = atan2(y - this->y, x - this->x);
        SPG_Circle(state->screen, this->x + 70*cos(angle), this->y + 70*sin(angle), 4, RGB_YELLOW);
    }
}

void Player::drawLife(GameState* state)
{
    SPG_RectRoundFilledBlend(state->screen, 300, 10, 500, 50, 8, RGB_BLACK, 100);
    if(hp > 0)
        SPG_RectRoundFilledBlend(state->screen, 310, 20, 310 + 180*hp/100.0, 40, 5, RGB_RED, 200);
}

void Player::moveUp()
{
    accy = -800;
    animUp.play();
}
void Player::moveDown()
{
    accy = 800;
    animDown.play();
}
void Player::moveLeft()
{
    accx = -800;
    animLeft.play();
}
void Player::moveRight()
{
    accx = 800;
    animRight.play();
}
void Player::stopUp()
{
    accy = 0;
    animUp.stop();
}
void Player::stopDown()
{
    accy = 0;
    animDown.stop();
}
void Player::stopLeft()
{
    accx = 0;
    animLeft.stop();
}
void Player::stopRight()
{
    accx = 0;
    animRight.stop();
}

void Player::startBurn(GameState* state, float x, float y)
{
    if(burning)
        return;
    
    burning = true;
    
    continueBurn(state, x, y);
}

void Player::continueBurn(GameState* state, float x, float y)
{
    if(!burning)
        return;
    
    //float speed = distance(velx, vely);
    float dist = distance(x, y, this->x, this->y);
    
    if(dist < 25)
        ;
    else if(dist < 70)
        addFire(state, x, y);
    else
    {
        float angle = atan2(y - this->y, x - this->x);
        addFire(state, this->x + 70*cos(angle), this->y + 70*sin(angle));
    }
    
    burnTimer = 0.005;
}

void Player::addFire(GameState* state, float x, float y)
{
    state->addBackFire(x, y);
}

void Player::endBurn()
{
    burning = false;
}

